set sql_safe_updates=0;

-- Attendance Day Wise Father Absent Only

SET @sgAttendanceDWFA=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_DAY_WISE_FATHER_ABSENT_ONLY_RCPNT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    (Case 
    when T8.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T8.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T8.logoUrl)end) as LOGO_URL
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
        LEFT JOIN
    organizations org ON org.id = 1
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'ABSENT' AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'FATHER' AND T6.whetherDeleted = false" WHERE `dataProviderId` = @sgAttendanceDWFA;

    
    
SET @sgsgAttendanceDWFATemConf=(SELECT id FROM msg_template_config WHERE `code`='Attendance Day Wise Father Absent Only');


UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body data-gramm="true" data-gramm_editor="true" data-gramm_id="374576b7-a0e7-6722-9571-8d6c535944eb">
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;], </span></span><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">$recipientData[&quot;STUDENT_FIRST_NAME&quot;] $recipientData[&quot;STUDENT_LAST_NAME&quot;] has been marked as $recipientData[&quot;ATTENDANCE_STATUS&quot;] on&nbsp;$recipientData[&quot;SESSION_DATE&quot;] by $recipientData[&quot;FACULTY_SALUTATION_NAME&quot;] $recipientData[&quot;FACULTY_PRINT_NAME&quot;]. </span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Should you have any queries or concerns please do not hesitate to contact</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</span></span></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @sgsgAttendanceDWFATemConf and msgDeliveryModeId in (1,4);



-- Attendance Day Wise Mother Absent Only

SET @sgAttendanceDWMA=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_DAY_WISE_MOTHER_ABSENT_ONLY_RCPNT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    (Case 
    when T8.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T8.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T8.logoUrl)end) as LOGO_URL
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
        LEFT JOIN
    organizations org ON org.id = 1
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'ABSENT' AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'MOTHER' AND T6.whetherDeleted = false" WHERE `dataProviderId` = @sgAttendanceDWMA;

    
    
SET @sgsgAttendanceDWMATemConf=(SELECT id FROM msg_template_config WHERE `code`='Attendance Day Wise Mother Absent Only');


UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body data-gramm="true" data-gramm_editor="true" data-gramm_id="374576b7-a0e7-6722-9571-8d6c535944eb">
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;], </span></span><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">$recipientData[&quot;STUDENT_FIRST_NAME&quot;] $recipientData[&quot;STUDENT_LAST_NAME&quot;] has been marked as $recipientData[&quot;ATTENDANCE_STATUS&quot;] on&nbsp;$recipientData[&quot;SESSION_DATE&quot;] by $recipientData[&quot;FACULTY_SALUTATION_NAME&quot;] $recipientData[&quot;FACULTY_PRINT_NAME&quot;]. </span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Should you have any queries or concerns please do not hesitate to contact</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</span></span></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>
' WHERE `msgTemplateConfigId`= @sgsgAttendanceDWMATemConf and msgDeliveryModeId in (1,4);


-- Update Attendance Day Wise Guardian

SET @sgAttendanceDWG=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_DAY_WISE_GUARDIAN_RCPNT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = T2.attendanceStatus) then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) as ATTENDANCE_STATUS,
    date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE,
    (Case 
    when T8.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T8.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T8.logoUrl)end) as LOGO_URL
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T1.lastUpdatedBy
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
        LEFT JOIN
    organizations org ON org.id = 1
WHERE
T1.id IN (namedParams) AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'GUARDIAN' AND T6.whetherDeleted = false" WHERE `dataProviderId` = @sgAttendanceDWG;

    
    
SET @sgsgAttendanceDWGTemConf=(SELECT id FROM msg_template_config WHERE `code`='Update Attendance Day Wise Guardian');


UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;PRINT_NAME&quot;],&nbsp;</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Attendance of $recipientData[&quot;STUDENT_PRINT_NAME&quot;] has been updated to &nbsp;&quot;$recipientData[&quot;ATTENDANCE_STATUS&quot;]&quot; on&nbsp;$recipientData[&quot;SESSION_DATE&quot;] by $recipientData[&quot;FACULTY_PRINT_NAME&quot;].<br />
			<br />
			Regards<br />
			$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</span></span></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>
' WHERE `msgTemplateConfigId`= @sgsgAttendanceDWGTemConf and msgDeliveryModeId in (1,4);


-- Update Attendance Day Wise Local Guardian

SET @sgAttendanceDWLG=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_DAY_WISE_LOCAL_GUARDIAN_RCPNT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = T2.attendanceStatus) then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) as ATTENDANCE_STATUS,
    date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE,
    (Case 
    when T8.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T8.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T8.logoUrl)end) as LOGO_URL
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T1.lastUpdatedBy
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
        LEFT JOIN
    organizations org ON org.id = 1
WHERE
T1.id IN (namedParams) AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'LOCAL_GUARDIAN' AND T6.whetherDeleted = false" WHERE `dataProviderId` = @sgAttendanceDWLG;

    
    
SET @sgsgAttendanceDWLGTemConf=(SELECT id FROM msg_template_config WHERE `code`='Update Attendance Day Wise Local Guardian');


UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;PRINT_NAME&quot;],&nbsp;</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Attendance of $recipientData[&quot;STUDENT_PRINT_NAME&quot;] has been updated to &nbsp;&quot;$recipientData[&quot;ATTENDANCE_STATUS&quot;]&quot; on&nbsp;$recipientData[&quot;SESSION_DATE&quot;] by $recipientData[&quot;FACULTY_PRINT_NAME&quot;].<br />
			<br />
			Regards<br />
			$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</span></span></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>
' WHERE `msgTemplateConfigId`= @sgsgAttendanceDWLGTemConf and msgDeliveryModeId in (1,4);


-- Update Attendance Day Wise Father Only DL

SET @sgAttendanceDWF=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_DAY_WISE_FATHER_RCPNT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
(case when (T2.itemValue = T2.attendanceStatus) then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) as ATTENDANCE_STATUS,
date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE,
(Case 
    when T8.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T8.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T8.logoUrl)end) as LOGO_URL
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T1.lastUpdatedBy
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
        LEFT JOIN
    organizations org ON org.id = 1
WHERE
T1.id IN (namedParams) AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'FATHER' AND T6.whetherDeleted = false" WHERE `dataProviderId` = @sgAttendanceDWF;

    
    
SET @sgsgAttendanceDWFTemConf=(SELECT id FROM msg_template_config WHERE `code`='Update Attendance Day Wise Father Only DL');


UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;PRINT_NAME&quot;],&nbsp;</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Attendance of $recipientData[&quot;STUDENT_PRINT_NAME&quot;] has been updated to &nbsp;&quot;$recipientData[&quot;ATTENDANCE_STATUS&quot;]&quot; on&nbsp;$recipientData[&quot;SESSION_DATE&quot;] by $recipientData[&quot;FACULTY_PRINT_NAME&quot;].<br />
			<br />
			Regards<br />
			$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</span></span></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @sgsgAttendanceDWFTemConf and msgDeliveryModeId in (1,4);


-- Update Attendance Day Wise Mother Only

SET @sgAttendanceDWM=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_DAY_WISE_MOTHER_RCPNT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
(case when (T2.itemValue = T2.attendanceStatus) then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) as ATTENDANCE_STATUS,
date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE,
(Case 
    when T8.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T8.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T8.logoUrl)end) as LOGO_URL
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T1.lastUpdatedBy
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
        LEFT JOIN
    organizations org ON org.id = 1
WHERE
T1.id IN (namedParams) AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'MOTHER' AND T6.whetherDeleted = false" WHERE `dataProviderId` = @sgAttendanceDWM;

    
    
SET @sgsgAttendanceDWMTemConf=(SELECT id FROM msg_template_config WHERE `code`='Update Attendance Day Wise Mother Only');


UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;PRINT_NAME&quot;],&nbsp;</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Attendance of $recipientData[&quot;STUDENT_PRINT_NAME&quot;] has been updated to &nbsp;&quot;$recipientData[&quot;ATTENDANCE_STATUS&quot;]&quot; on&nbsp;$recipientData[&quot;SESSION_DATE&quot;] by $recipientData[&quot;FACULTY_PRINT_NAME&quot;].<br />
			<br />
			Regards<br />
			$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</span></span></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>
' WHERE `msgTemplateConfigId`= @sgsgAttendanceDWMTemConf and msgDeliveryModeId in (1,4);


-- Attendance Day Wise Guardian Absent Only

SET @sgAttendanceDWGA=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_DAY_WISE_GUARDIAN_ABSENT_ONLY_RCPNT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    (Case 
    when T8.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T8.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T8.logoUrl)end) as LOGO_URL
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
	LEFT JOIN
    organizations org ON org.id = 1
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'ABSENT' AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'GUARDIAN' AND T6.whetherDeleted = false" WHERE `dataProviderId` = @sgAttendanceDWGA;

    
    
SET @sgsgAttendanceDWGATemConf=(SELECT id FROM msg_template_config WHERE `code`='Attendance Day Wise Guardian Absent Only');


UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body data-gramm="true" data-gramm_editor="true" data-gramm_id="374576b7-a0e7-6722-9571-8d6c535944eb">
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;], </span></span><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">$recipientData[&quot;STUDENT_FIRST_NAME&quot;] $recipientData[&quot;STUDENT_LAST_NAME&quot;] has been marked as $recipientData[&quot;ATTENDANCE_STATUS&quot;] on&nbsp;$recipientData[&quot;SESSION_DATE&quot;] by $recipientData[&quot;FACULTY_SALUTATION_NAME&quot;] $recipientData[&quot;FACULTY_PRINT_NAME&quot;]. </span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Should you have any queries or concerns please do not hesitate to contact</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</span></span></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>
' WHERE `msgTemplateConfigId`= @sgsgAttendanceDWGATemConf and msgDeliveryModeId in (1,4);


-- Attendance Day Wise Local Guardian Absent Only

SET @sgAttendanceDWLGA=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_DAY_WISE_LOCAL_GUARDIAN_ABSENT_ONLY_RCPNT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    (Case 
    when T8.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T8.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T8.logoUrl)end) as LOGO_URL
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    organizations org ON org.id = 1
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'ABSENT' AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'LOCAL_GUARDIAN' AND T6.whetherDeleted = false" WHERE `dataProviderId` = @sgAttendanceDWLGA;

    
    
SET @sgsgAttendanceDWLGATemConf=(SELECT id FROM msg_template_config WHERE `code`='Attendance Day Wise Local Guardian Absent Only');


UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<p><br />
<title></title>
</p>

<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;], </span></span><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">$recipientData[&quot;STUDENT_FIRST_NAME&quot;] $recipientData[&quot;STUDENT_LAST_NAME&quot;] has been marked as $recipientData[&quot;ATTENDANCE_STATUS&quot;] on&nbsp;$recipientData[&quot;SESSION_DATE&quot;] by $recipientData[&quot;FACULTY_SALUTATION_NAME&quot;] $recipientData[&quot;FACULTY_PRINT_NAME&quot;]. </span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Should you have any queries or concerns please do not hesitate to contact</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</span></span></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @sgsgAttendanceDWLGATemConf and msgDeliveryModeId in (1,4);

set sql_safe_updates=1;

